' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class BugProperties
  Inherits System.Web.UI.Page
  Private itemType As String
  Private itemText As String

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    itemType = lstType.SelectedValue
    itemText = lstType.SelectedItem.Text
    sdsSingleItem.InsertCommand = "sproc" + itemType + "InsertUpdateSingleItem"
    sdsSelectList.SelectCommand = "sproc" + itemType + "SelectList"
    sdsSelectList.UpdateCommand = "sproc" + itemType + "InsertUpdateSingleItem"
    If Not Page.IsPostBack() Then
      LoadData()
    End If
  End Sub

  Protected Sub lstType_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstType.SelectedIndexChanged
    LoadData()
  End Sub

  Private Sub LoadData()
    ' Dynamicznie ustawia procedury operacji select, insert i update dla obiektu sdsSingleItem typu DataSource
    ' Wykonujemy to tylko podczas pocztkowego adowania i za kadym razem, gdy  
    ' z listy rozwijanej wybierana jest inna pozycja
    GridView1.DataBind()
    lblType1.Text = itemText
    lblType2.Text = itemText
  End Sub

  Protected Sub GridView1_RowUpdated(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewUpdatedEventArgs) Handles GridView1.RowUpdated
    ' Sprawd, czy wystapi bd
    If e.Exception Is Nothing Then
      ' Nastpnie zobacz ile wierszy zostao zaktualizowanych. 1 oznacza powodzenie, 0 lub -1 znaczy, e opis ju istnia
      If e.AffectedRows <> 1 Then
        lblStatus.Text = "Taki element waciwoci " & itemType & " ju istnieje. Prosz poda inny opis."
        e.KeepInEditMode = True
      End If
    Else
      lblStatus.Text = "Wystpi bd przy aktualizacji elementu waciwoci. Szczegy wyjtku: " + e.Exception.Message
    End If
  End Sub

  Protected Sub lnkCreateNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkCreateNew.Click
    FormView1.ChangeMode(FormViewMode.Insert)
    SwitchVisibilityMode(True)
  End Sub

  Protected Sub FormView1_ItemInserted(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.FormViewInsertedEventArgs) Handles FormView1.ItemInserted
    If e.Exception Is Nothing Then
      If Not (e.AffectedRows = 1) Then
        lblStatus.Text = "Taki element waciwoci ju istnieje. Prosz wybra inny opis."
        e.KeepInInsertMode = True
      Else
        SwitchVisibilityMode(False)
        LoadData()
      End If
    Else
      lblStatus.Text = "Wystpi bd przy aktualizacji elementu waciwoci. Szczegy wyjtku: " + e.Exception.Message
    End If
  End Sub

  Private Sub SwitchVisibilityMode(ByVal isInserting As Boolean)
    FormView1.Visible = isInserting
    GridView1.Visible = Not isInserting
    lnkCreateNew.Visible = Not isInserting
    plcList.Visible = Not isInserting
  End Sub

  Protected Sub FormView1_ItemCommand(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.FormViewCommandEventArgs) Handles FormView1.ItemCommand
    Select Case e.CommandName.ToUpper()
      Case "CANCEL"
        SwitchVisibilityMode(False)
    End Select
  End Sub

  Protected Sub GridView1_RowCommand(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewCommandEventArgs) Handles GridView1.RowCommand
    LoadData()
  End Sub

  Protected Sub GridView1_DataBound(ByVal sender As Object, ByVal e As System.EventArgs) Handles GridView1.DataBound
    ' Sformatuj nasz pasek z odnonikami do stron
    If GridView1.TopPagerRow IsNot Nothing Then
      Helpers.FormatGridViewPagerBar(GridView1.TopPagerRow)
    End If
    If GridView1.BottomPagerRow IsNot Nothing Then
      Helpers.FormatGridViewPagerBar(GridView1.BottomPagerRow)
    End If
  End Sub
End Class
